local assets =
{
	Asset("ANIM", "anim/cz83cile.zip"),
    Asset("ATLAS", "images/inventoryimages/cz83cile.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("cz83cile")
    inst.AnimState:SetBuild("cz83cile")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end


    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "cz83cile"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/cz83cile.xml"
    inst:AddComponent("selfstacker")
	inst:AddComponent("stackable")

    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("cz83cile", fn, assets)